#ifndef __CMenu__
#define __CMenu__

#include "CMenuItem.hpp"
#include <Collections/TCountedPointerArray.hpp>

//	===========================================================================

using Exponent::GUI::Controls::CMenuItem;
using Exponent::Collections::TCountedPointerArray;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CMenu CMenu.hpp
			 * @brief A menu (basically a simple list)
			 *
			 * @date 12/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CMenu.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			class CMenu : public CCountedObject
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				CMenu();

				/**
				 * Destruction
				 */
				virtual ~CMenu();

//	===========================================================================

				/**
				 * Add a sub menu item
				 * @param menuItem The menu item to add
				 */
				void addMenuItem(CMenuItem *menuItem);

				/**
				 * Get a menu item
				 * @param index The index of the item required
				 * @retval CMenuItem* The menu item requested, or null on error
				 */
				CMenuItem *getMenuItem(const long index);
				
				/**
				 * Remove a menu itme
				 * @param index The index of the item to remove
				 */
				void removeMenuItem(const long index);

				/**
				 * Remove a menu item - doesnt reorder the internal array
				 * @param index The index of the menu item to remove
				 */
				void removeMenuItemNoOrdering(const long index);

				/**
				 * Remove all the menu items
				 */
				void clearAllMenuItems();

				/**
				 * Set the menu title
				 * @param title The title of the menu
				 */
				void setMenuTitle(const CString &title);

				/**
				 * Get the menu title
				 * @retval const CString& The title of the menu
				 */
				const CString &getMenuTitle() const;

				/**
				 * Get the number of menu items
				 * @retval long The number of menu items contained within
				 */
				long getNumberOfMenuItems() const;

//	===========================================================================

				/**
				 * Fill a menu up with tempo divisions
				 * @param addToThisMenu The menu to add to
				 */
				static void getADivisionMenu(CMenu *addToThisMenu);

//	===========================================================================

			protected:

//	===========================================================================

				TCountedPointerArray<CMenuItem> *m_subMenus;		/**< The sub menu items */
				CString m_menuTitle;								/**< The title of the menu */

			};
		}
	}
}
#endif	// End of CMenu.hpp